/*
 * Decompiled with CFR 0.152.
 */
package de.joergjahnke.c64.drive;

import de.joergjahnke.c64.core.C64FileEntry;
import de.joergjahnke.c64.drive.DriveHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public abstract class TapeDriveHandler
extends DriveHandler {
    protected int tapePosition = 0;

    protected byte[] readTapeData(int size) {
        byte[] tapeBytes = new byte[size];
        int first = this.tapePosition;
        int last = first + size;
        if (last > this.bytes.length) {
            throw new RuntimeException("Preliminary end of tape. Could not tape data!");
        }
        System.arraycopy(this.bytes, first, tapeBytes, 0, size);
        this.tapePosition = last;
        return tapeBytes;
    }

    protected void gotoTapePosition(int position) {
        this.tapePosition = position;
    }

    @Override
    public byte[] readFile(C64FileEntry fileEntry) {
        int fileLen = fileEntry.fileLength >= 0 ? fileEntry.fileLength : this.bytes.length - this.tapePosition;
        ByteArrayOutputStream out = new ByteArrayOutputStream(fileLen);
        out.write(fileEntry.startAddress & 0xFF);
        out.write((fileEntry.startAddress & 0xFF00) >> 8);
        this.gotoTapePosition(fileEntry.offset);
        try {
            out.write(this.readTapeData(fileLen));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toByteArray();
    }
}

